
layout(triangles) in;
layout(triangle_strip, max_vertices = 32) out;

uniform int curr_rendering_light = 0;

//in vec2 uv;
//in vec3 norm;
in vec3 ws_pos[];

out vec3 out_pos;


void main() {
    Light light = lights[curr_rendering_light];

    mat4 view_mat = light.view_mat;
    mat4 proj_mat = light.proj_mat;
//    proj_mat = lights[0].proj_mat;

    if(light.type == LIGHT_TYPE_POINT){
        for(int face = 0; face < 6; ++face) {
            gl_Layer = face;
            for(int i = 0; i < 3; ++i) {
                mat4 view_mat = light.view_mats_point[face];
                out_pos = ws_pos[i];
                gl_Position = vec4(ws_pos[i],1);
                gl_Position = proj_mat * view_mat * gl_Position;
                EmitVertex();
            }
            EndPrimitive();
        }
    } else {
        for(int i = 0; i < 3; i++) {
            gl_Position = vec4(ws_pos[i],1);
            gl_Position = proj_mat * view_mat * gl_Position;
//            gl_Position.x += 0.1;
//            gl_Position.xyz /= gl_Position.w;
            EmitVertex();
        }
        EndPrimitive();
    }



}
